﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class ReadFilePanel
    Inherits FileSystemSample.TaskPanelBase

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents FileContentsTextBox As System.Windows.Forms.TextBox


    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        Me.FileContentsTextBox = New System.Windows.Forms.TextBox
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.Text = "When reading the entire contents of a file, the My.Computer.FileSystem.ReadAllTex" & _
            "t method can be used.  "
        '
        'ExececuteMethodButton
        '
        '
        'ResetValuesButton
        '
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.FileContentsTextBox)
        Me.GroupBox2.Controls.SetChildIndex(Me.FileContentsTextBox, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.EndParenLabel, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ExececuteMethodButton, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ResetValuesButton, 0)
        '
        'FileContentsTextBox
        '
        Me.FileContentsTextBox.AutoSize = False
        Me.FileContentsTextBox.Location = New System.Drawing.Point(27, 193)
        Me.FileContentsTextBox.Multiline = True
        Me.FileContentsTextBox.Name = "FileContentsTextBox"
        Me.FileContentsTextBox.ReadOnly = True
        Me.FileContentsTextBox.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.FileContentsTextBox.Size = New System.Drawing.Size(539, 178)
        Me.FileContentsTextBox.TabIndex = 4
        '
        'ReadFilePanel
        '
        Me.Name = "ReadFilePanel"
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Shared panelInstance As ReadFilePanel
    Friend WithEvents readFileFileChooser As New FileChooser()
    Friend WithEvents encodingComboBox As New ComboBox()

    ''' <summary>
    ''' 获取此面板的全局实例
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As ReadFilePanel
        If (panelInstance Is Nothing) Then
            panelInstance = New ReadFilePanel
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板，为 ReadAllText() 的每个参数添加一个控件
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ReadFile_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("filename", readFileFileChooser)
        MyBase.AddParameter("encoding", encodingComboBox)
    End Sub


    ''' <summary>
    ''' 将这些控件初始化为它们的默认值。
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        Me.readFileFileChooser.Reset()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.ReadAllText("
        encodingComboBox.Items.AddRange(New String() {"ASCII", "BigEndianUnicode", "Unicode", "UTF7", "UTF8", "UTF32"})
        encodingComboBox.AutoSize = True
        encodingComboBox.SelectedItem = "ASCII"
    End Sub

    ''' <summary>
    ''' 用所提供的参数值执行 ReadAllText() 方法。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        Try
            Me.FileContentsTextBox.Text = My.Computer.FileSystem.ReadAllText( _
                                                            file:=readFileFileChooser.Filename, _
                                                            encoding:=ParseEncoding(CType(Me.encodingComboBox.SelectedItem, String)))
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ''' <summary>
    ''' 将这些控件重置为它们的默认值
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub

End Class
